<!-- Custom Style for Integration & Gateways -->
<style>
    :root {
        --primary-color: #000000;
        --gradient-1: linear-gradient(135deg, #333333 0%, #666666 100%);
        --gradient-2: linear-gradient(135deg, #555555 0%, #888888 100%);
        --gradient-3: linear-gradient(135deg, #000000 0%, #444444 100%);
    }

    body {
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
        color: #1d1d1f;
        overflow-x: hidden;
    }

    .integration-section {
        background-color: #ffffff;
        padding: 80px 0;
        border-bottom: 1px solid #f2f2f2;
    }

    .gateway-section {
        background-color: #fbfbfd;
        padding: 80px 0;
        border-top: 1px solid #f2f2f2;
        border-bottom: 1px solid #f2f2f2;
    }

    .logo-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 30px;
        align-items: center;
        justify-items: center;
    }

    .logo-item {
        transition: 0.3s;
        filter: grayscale(100%);
        opacity: 0.6;
        max-width: 110px;
    }

    .logo-item:hover {
        filter: grayscale(0%);
        opacity: 1;
        transform: scale(1.05);
    }

    .gateway-box {
        background: #fff;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.03);
        border: 1px solid #eee;
        transition: 0.3s;
        height: 75px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .gateway-box:hover {
        border-color: var(--primary-color);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
    }

    /* Updated Stats Section Styles - Compact Version */
    .stats-card {
        background: white;
        border-radius: 16px;
        padding: 20px 15px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.05);
        border: 1px solid #f0f0f0;
        transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.1);
        position: relative;
        overflow: hidden;
        height: 100%;
        text-align: center;
    }

    .stats-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
        background: #000000;
        opacity: 0;
        transition: opacity 0.3s;
    }

    .stats-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.1);
    }

    .stats-card:hover::before {
        opacity: 1;
    }

    .stats-number {
        font-size: 2rem;
        font-weight: 800;
        color: #000000;
        line-height: 1;
        margin-bottom: 8px;
        letter-spacing: -0.5px;
    }

    .stats-label {
        color: #666;
        font-weight: 500;
        font-size: 0.85rem;
        letter-spacing: 0.5px;
    }

    /* Hero Image Animation */
    .hero-img-container {
        position: relative;
        display: inline-block;
    }

    .hero-img-container img {
        animation: float 6s ease-in-out infinite;
        filter: drop-shadow(0 20px 30px rgba(0, 0, 0, 0.1));
    }

    @keyframes float {
        0%,
        100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-20px);
        }
    }

    .hero-visual-element {
        position: absolute;
        border-radius: 50%;
        opacity: 0.15;
        z-index: -1;
        background: #000000;
    }

    .element-1 {
        width: 250px;
        height: 250px;
        top: -40px;
        right: -40px;
        animation: pulse 4s ease-in-out infinite;
    }

    .element-2 {
        width: 180px;
        height: 180px;
        bottom: -25px;
        left: -25px;
        animation: pulse 5s ease-in-out infinite reverse;
    }

    @keyframes pulse {
        0%,
        100% {
            transform: scale(1);
        }
        50% {
            transform: scale(1.05);
        }
    }

    /* Compact Features Section Styles */
    .feature-card-compact {
        transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.1);
        border: 1px solid rgba(0, 0, 0, 0.08);
        height: 100%;
    }

    .feature-card-compact:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
        border-color: rgba(0, 0, 0, 0.2);
    }

    .feature-icon-compact {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
        background: linear-gradient(135deg, #000000, #333333);
        color: white;
    }

    .feature-icon-compact i {
        font-size: 1.25rem;
    }

    .feature-title-compact {
        font-weight: 700;
        font-size: 1.1rem;
        color: #000000;
        margin-bottom: 10px;
    }

    .feature-desc-compact {
        color: #666;
        font-size: 0.9rem;
        line-height: 1.5;
        margin-bottom: 15px;
    }

    .feature-point-compact {
        font-size: 0.85rem;
        color: #555;
        margin-bottom: 5px;
    }

    .feature-point-compact i {
        font-size: 0.8rem;
        margin-right: 8px;
        color: #000000;
    }
</style>
<!-- ======= Hero Section ======= -->
<section id="hero" class="hero d-flex align-items-center" style="padding: 120px 0 60px 0; background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);">
    <div class="container">
        <div class="row align-items-center text-center text-lg-start">
            <div class="col-lg-6">
                <span class="badge bg-light text-dark px-3 py-2 mb-3 fw-bold border border-dark" style="background: #f8f9fa !important;">Trusted by 2,000+ Businesses</span>
                <h1 style="font-size: 48px; font-weight: 800; color: #000000; letter-spacing: -1px; line-height: 1.2;">
                    Simplify Your
                    <br><span style="color: #000000;">Payment Workflow</span>
                </h1>
                <p style="font-size: 18px; color: #666; margin-top: 20px; line-height: 1.6;">
                    The ultimate MFS automation platform. Secure, developer-friendly, and ready for any platform.
                </p>
                <div class="mt-4 d-flex justify-content-center justify-content-lg-start gap-3">
                    <a href="/sign-up" class="btn btn-dark btn-lg px-4" style="border-radius: 30px; font-weight: 600; background: #000000; border-color: #000000;">Get Started Free</a>
                    <a href="#about" class="btn btn-outline-dark btn-lg px-4" style="border-radius: 30px; border-color: #333; color: #333;">See Features</a>
                </div>
            </div>
            <div class="col-lg-6 hero-img mt-5 mt-lg-0 text-center position-relative">
                <div class="hero-img-container">
                    <img src="<?= base_url('public/assets/plat') ?>/payment-home-photo.png" class="img-fluid" style="max-width: 85%;" alt="Payment System">
                </div>
                <div class="hero-visual-element element-1"></div>
                <div class="hero-visual-element element-2"></div>
            </div>
        </div>
    </div>
</section>
<main id="main">
    <!-- ======= Compact Statistics Section ======= -->
    <section id="stats" class="py-4" style="background-color: #ffffff;">
        <div class="container py-3">
            <div class="row g-3">
                <div class="col-6 col-md-3">
                    <div class="stats-card">
                        <div class="stats-number">10K+</div>
                        <div class="stats-label">Happy Clients</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stats-card">
                        <div class="stats-number">$2M+</div>
                        <div class="stats-label">Total Volume</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stats-card">
                        <div class="stats-number">32+</div>
                        <div class="stats-label">Gateways</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stats-card">
                        <div class="stats-number">100%</div>
                        <div class="stats-label">Security</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ======= Supported Platforms Section ======= -->
    <section id="platforms" class="integration-section">
        <div class="container">
            <div class="text-center mb-5">
                <span class="text-uppercase small fw-bold text-muted" style="letter-spacing: 1.5px;">Integrations</span>
                <h3 class="fw-bold mt-2" style="color: #000000;">Compatible with your favorite platforms</h3>
            </div>
            <div class="logo-grid opacity-75">
                <img src="public/assets/plat/php.png" class="logo-item" alt="PHP">
                <img src="public/assets/plat/javascript.png" class="logo-item" alt="JS">
                <img src="public/assets/plat/nodejs.png" class="logo-item" alt="NodeJS">
                <img src="public/assets/plat/whmcs-logo.png" class="logo-item" alt="WHMCS">
                <img src="public/assets/plat/woocommerce-logo-transparent.png" class="logo-item" alt="WooCommerce">
                <img src="public/assets/plat/wordpress-logo-stacked-rgb.png" class="logo-item" alt="WordPress">
                <img src="public/assets/plat/smm.png" class="logo-item" alt="SMM Panel">
            </div>
        </div>
    </section>
    <!-- ======= Compact Features Section ======= -->
    <section id="about" class="py-5 bg-white">
        <div class="container py-4">
            <div class="row g-4">
                <!-- Automated Processing -->
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card-compact p-4 rounded-3 bg-white">
                        <div class="feature-icon-compact">
                            <i class="bi bi-lightning-charge-fill"></i>
                        </div>
                        <h4 class="feature-title-compact">Automated Processing</h4>
                        <p class="feature-desc-compact">Verify transactions instantly with our automated system. Zero manual work required for seamless operations.</p>
                        <div class="feature-points">
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>Instant verification</span>
                            </div>
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>Zero manual work</span>
                            </div>
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>24/7 automation</span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Enterprise Security -->
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card-compact p-4 rounded-3 bg-white">
                        <div class="feature-icon-compact">
                            <i class="bi bi-shield-lock-fill"></i>
                        </div>
                        <h4 class="feature-title-compact">Enterprise Security</h4>
                        <p class="feature-desc-compact">Bank-grade encryption ensures your payment data and accounts remain safe 24/7 with enterprise protection.</p>
                        <div class="feature-points">
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>Bank-level encryption</span>
                            </div>
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>24/7 protection</span>
                            </div>
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>Fraud monitoring</span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Developer First API -->
                <div class="col-lg-4 col-md-6">
                    <div class="feature-card-compact p-4 rounded-3 bg-white">
                        <div class="feature-icon-compact">
                            <i class="bi bi-code-slash"></i>
                        </div>
                        <h4 class="feature-title-compact">Developer First API</h4>
                        <p class="feature-desc-compact">Simple, documentation-driven API that you can integrate in less than 15 minutes with extensive support.</p>
                        <div class="feature-points">
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span><15 min integration</span>
                            </div>
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>Clear documentation</span>
                            </div>
                            <div class="feature-point-compact">
                                <i class="bi bi-check-circle-fill"></i>
                                <span>Multiple SDKs</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="py-5" style="background-color: #f8f9fa;">
        <div class="container py-5 text-center">
            <div class="mb-5">
                <h2 class="fw-bold display-6" style="color: #000000;">Simple, Transparent Pricing</h2>
                <p class="text-muted">Choose the best plan for your business growth</p>
            </div>
            <div class="row g-4 justify-content-center">
                <?php if (!empty($plans)) : foreach ($plans as $plan) : ?>
                        <div class="col-lg-3 col-md-6 text-start">
                            <div class="card h-100 border-0 shadow-sm p-4" style="border-radius: 20px; border: 1px solid #e0e0e0 !important;">
                                <div class="card-body">
                                    <span class="text-dark fw-bold small text-uppercase"><?= $plan['name'] ?></span>
                                    <h2 class="fw-bold mt-2 mb-0" style="color: #000000;"><?= currency_format($plan['final_price']) ?></h2>
                                    <p class="text-muted small mb-4">/ <?= duration_type($plan['name'], $plan['duration_type'], $plan['duration'], false) ?></p>
                                    <hr class="my-4 opacity-10">
                                    <ul class="list-unstyled mb-5 small lh-lg">
                                        <li><i class="bi bi-check2 text-dark me-2"></i><?= plan_message('brand', $plan['brand']) ?></li>
                                        <li><i class="bi bi-check2 text-dark me-2"></i><?= plan_message('device', $plan['device']) ?></li>
                                        <li><i class="bi bi-check2 text-dark me-2"></i><?= plan_message('transaction', $plan['transaction']) ?></li>
                                    </ul>
                                    <a href="<?= user_url('plans') ?>" class="btn btn-dark w-100 py-2 rounded-pill fw-bold" style="background: #000000; border-color: #000000;">Subscribe Now</a>
                                </div>
                            </div>
                        </div>
                <?php endforeach;
                endif; ?>
            </div>
        </div>
    </section>
    <!-- ======= FAQ Section ======= -->
    <section id="faq" class="py-5 bg-white border-top">
        <div class="container py-5">
            <h2 class="fw-bold text-center mb-5 display-6" style="color: #000000;">Frequently Asked Questions</h2>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="accordion accordion-flush" id="faqlist">
                        <?php if (!empty($items)) : foreach ($items as $key => $item) : ?>
                                <div class="accordion-item mb-3 border rounded shadow-none">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed fw-bold shadow-none bg-white py-3" type="button" data-bs-toggle="collapse" data-bs-target="#faq-<?= $item['id'] ?>" style="color: #000000;">
                                            <?= htmlspecialchars($item['question']) ?>
                                        </button>
                                    </h2>
                                    <div id="faq-<?= $item['id'] ?>" class="accordion-collapse collapse" data-bs-parent="#faqlist">
                                        <div class="accordion-body text-secondary small lh-lg"><?= $item['answer'] ?></div>
                                    </div>
                                </div>
                        <?php endforeach;
                        endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ======= Supported Gateways Section ======= -->
    <section id="gateways" class="gateway-section">
        <div class="container">
            <div class="text-center mb-5">
                <h3 class="fw-bold" style="color: #000000;">Supported Gateways</h3>
                <p class="text-muted small">We verify and process payments through 32+ local and international methods</p>
            </div>
            <div class="row g-3 justify-content-center">
                <?php if (!empty($payments)) : foreach ($payments as $payment) : ?>
                        <div class="col-6 col-md-3 col-lg-2">
                            <div class="gateway-box">
                                <img src="<?= base_url() . @get_value(get_value($payment['params'], 'option'), 'logo'); ?>" class="logo-item" style="max-height: 35px;" alt="Gateway">
                            </div>
                        </div>
                <?php endforeach;
                endif; ?>
            </div>
        </div>
    </section>
    <!-- ======= Updated Contact Section ======= -->
    <section id="contact" class="py-5 border-top bg-white">
        <div class="container py-5">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <h2 class="fw-bold mb-4 display-5" style="color: #000000;">Ready to Transform Your Payment Workflow?</h2>
                    <p class="text-muted lead mb-5">Join thousands of businesses already using our platform to streamline their payment processes</p>
                    <a href="/sign-up" class="btn btn-dark btn-lg px-5 py-3 fw-bold" style="border-radius: 30px; font-size: 1.1rem; background: #000000; border-color: #000000;">
                        Get Started Free Today
                        <i class="bi bi-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </section>
</main>