<!doctype html>

<html lang="en">

<head>
<title><?= !empty($title) ? $title . ' - ' . site_config("site_title", "author") : site_config("site_title", "author") ?></title>
<meta charset="utf-8">
<meta content="width=device-width, initial-scale=1.0" name="viewport">

code
Code
download
content_copy
expand_less
<meta name="author" content="<?= site_config('site_description', 'author') ?>">
<meta name="description" content="<?= site_config('site_description', 'Site desc') ?>">
<meta name="theme-color" content="#ffffff">
<meta name="keywords" content="<?= site_config('site_keywords', "keywords") ?>">

<!-- Open Graph -->
<meta property="og:type" content="website">
<meta property="og:title" content="<?= !empty($title) ? $title . ' - ' . site_config("site_title", "author") : site_config("site_title", "author") ?>">
<meta property="og:description" content="<?= site_config('site_description', 'Site desc') ?>">
<meta property="og:image" content="<?= $og_image ?? get_logo() ?>">
<meta property="og:url" content="<?= current_url(true) ?>">
<meta property="og:site_name" content="<?= site_config("site_name", "My Site") ?>">

<link rel="icon" type="image/png" href="<?= get_logo(true) ?>" />
<link rel="apple-touch-icon" href="<?= get_logo() ?>" />
<link rel="canonical" href="<?= base_url() ?>">

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<?= link_asset('frontend/vendor/aos/aos.css') ?>
<?= link_asset('frontend/vendor/bootstrap/css/bootstrap.min.css') ?>
<?= link_asset('frontend/vendor/bootstrap-icons/bootstrap-icons.css') ?>
<?= link_asset('frontend/vendor/glightbox/css/glightbox.min.css') ?>
<?= link_asset('frontend/vendor/remixicon/remixicon.css') ?>
<?= link_asset('frontend/vendor/swiper/swiper-bundle.min.css') ?>
<?= link_asset('frontend/css/style.css') ?>

<style>
    :root {
        --primary: #6366f1;
        --primary-soft: #eef2ff;
        --dark: #0f172a;
        --text-muted: #64748b;
        --bg-light: #f8fafc;
        --radius-lg: 1rem;
        --radius-md: 0.75rem;
        --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.04), 0 8px 10px -6px rgba(0, 0, 0, 0.04);
    }

    body {
        font-family: 'Plus Jakarta Sans', sans-serif;
        background-color: #ffffff;
        color: var(--dark);
    }

    /* Navbar Modernized */
    .header {
        background: rgba(255, 255, 255, 0.8) !important;
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        border-bottom: 1px solid #f1f5f9;
        padding: 1rem 0;
        transition: all 0.3s ease;
    }

    .navbar a {
        font-size: 0.95rem;
        font-weight: 500;
        color: var(--dark) !important;
        padding: 0.5rem 1.25rem !important;
        transition: 0.2s;
    }

    .navbar a:hover, .navbar .active {
        color: var(--primary) !important;
    }

    .getstarted {
        background: var(--primary) !important;
        color: #fff !important;
        border-radius: var(--radius-md) !important;
        padding: 0.6rem 1.5rem !important;
        font-weight: 600 !important;
        box-shadow: 0 4px 12px rgba(99, 102, 241, 0.25);
        margin-left: 1rem;
    }

    .getstarted:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 16px rgba(99, 102, 241, 0.35);
    }

    /* Footer Clean Design */
    .footer {
        background: var(--bg-light) !important;
        padding: 80px 0 40px;
        border-top: 1px solid #f1f5f9;
    }

    .footer h4 {
        font-size: 1.1rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
        color: var(--dark);
    }

    .footer-links ul li {
        padding: 0.4rem 0;
    }

    .footer-links ul li a {
        color: var(--text-muted);
        font-size: 0.95rem;
        transition: 0.3s;
    }

    .footer-links ul li a:hover {
        color: var(--primary);
        padding-left: 5px;
    }

    .social-links a {
        width: 40px;
        height: 40px;
        background: #fff;
        color: var(--text-muted);
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: var(--radius-md);
        margin-right: 0.75rem;
        border: 1px solid #f1f5f9;
        transition: 0.3s;
    }

    .social-links a:hover {
        background: var(--primary);
        color: #fff;
        border-color: var(--primary);
        transform: translateY(-3px);
    }

    /* Floating Action Buttons */
    .whatsapp-button {
        position: fixed;
        bottom: 2rem;
        right: 2rem;
        width: 60px;
        height: 60px;
        background: #22c55e;
        color: white !important;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.75rem;
        box-shadow: 0 10px 25px rgba(34, 197, 94, 0.3);
        z-index: 999;
        transition: 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    }

    .whatsapp-button:hover {
        transform: scale(1.1) rotate(10deg);
    }

    .back-to-top {
        width: 44px;
        height: 44px;
        border-radius: var(--radius-md);
        background: #fff;
        color: var(--primary);
        border: 1px solid #f1f5f9;
        box-shadow: var(--shadow);
        bottom: 7rem;
        transition: 0.3s;
    }

    /* Soft Modal UI */
    .modal-content {
        border: none;
        border-radius: var(--radius-lg);
        padding: 1rem;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
    }

    .modal-header {
        border-bottom: 0;
        padding-bottom: 0;
    }

    .copyright {
        margin-top: 60px;
        padding-top: 30px;
        border-top: 1px solid #e2e8f0;
        font-size: 0.9rem;
        color: var(--text-muted);
        letter-spacing: 0.5px;
    }
</style>
</head>

<body>

code
Code
download
content_copy
expand_less
<header id="header" class="header fixed-top">
    <div class="container d-flex align-items-center justify-content-between">
        <a href="<?= base_url(); ?>" class="logo">
            <img src="<?= get_logo() ?>" alt="Logo" style="height: 38px;">
        </a>

        <nav id="navbar" class="navbar">
            <ul>
                <li><a class="nav-link scrollto active" href="#hero">Home</a></li>
                <li><a class="nav-link scrollto" href="#about">About</a></li>
                <li><a class="nav-link scrollto" href="#pricing">Pricing</a></li>
                <li><a class="nav-link scrollto active" href="#faq">FAQ</a></li>
                <li><a href="<?= base_url('blogs') ?>">Blog</a></li>
                <li><a href="<?= base_url('developers') ?>">API Docs</a></li>
                <?php if (session('uid')): ?>
                    <li><a class="getstarted" href="<?= base_url('user/dashboard') ?>">Dashboard</a></li>
                <?php else: ?>
                    <li><a class="getstarted" href="<?= base_url('sign-in') ?>">Login</a></li>
                <?php endif; ?>
            </ul>
            <i class="bi bi-list mobile-nav-toggle"></i>
        </nav>
    </div>
</header>

<main id="main-content">
    <?= view($view); ?>
</main>

<footer id="footer" class="footer">
    <div class="container">
        <div class="row gy-5">
            <div class="col-lg-4 col-md-12">
                <a href="<?= base_url(); ?>" class="logo d-flex align-items-center mb-4">
                    <span style="font-size: 1.5rem; font-weight: 800; color: var(--dark);"><?= site_config('site_name'); ?></span>
                </a>
                <p style="color: var(--text-muted); line-height: 1.7;"><?= site_config('site_description') ?></p>
                <div class="social-links mt-4">
                    <a href="<?= site_config('social_facebook_link') ?>"><i class="bi bi-facebook"></i></a>
                    <a href="<?= site_config('social_instagram_link') ?>"><i class="bi bi-instagram"></i></a>
                    <a href="<?= site_config('social_twitter_link') ?>"><i class="bi bi-twitter"></i></a>
                    <a href="<?= site_config('social_youtube_link') ?>"><i class="bi bi-youtube"></i></a>
                </div>
            </div>

            <div class="col-lg-2 col-6 footer-links ms-auto">
                <h4>Company</h4>
                <ul class="list-unstyled">
                    <li><a href="<?= base_url("#about") ?>">Our Story</a></li>
                    <li><a href="<?= base_url("terms-condition") ?>">Terms of Service</a></li>
                    <li><a href="<?= base_url("privacy-policy") ?>">Privacy Policy</a></li>
                </ul>
            </div>

            <div class="col-lg-2 col-6 footer-links">
                <h4>Resources</h4>
                <ul class="list-unstyled">
                    <li><a href="<?= base_url('#faq') ?>">Help Center</a></li>
                    <li><a href="<?= base_url('#pricing') ?>">Pricing Plans</a></li>
                    <li><a href="<?= base_url('#services') ?>">Services</a></li>
                </ul>
            </div>

            <div class="col-lg-3 col-md-12">
                <h4>Get in Touch</h4>
                <p style="color: var(--text-muted); font-size: 0.95rem;">
                    <?= site_config('address') ?><br><br>
                    <strong>Email:</strong> <?= site_config('contact_email') ?><br>
                    <strong>Phone:</strong> <?= site_config('contact_tel') ?>
                </p>
            </div>
        </div>

        <div class="copyright text-center">
            COPYRIGHT © <script>document.write(new Date().getFullYear())</script> ZAPPAY.TOP
        </div>
    </div>
</footer>

<?php echo htmlspecialchars_decode(get_option('embed_javascript', ''), ENT_QUOTES); ?>

<!-- WhatsApp & Top -->
<a href="https://wa.me/8801947523263" class="whatsapp-button" target="_blank" rel="noopener">
    <i class="fab fa-whatsapp"></i>
</a>
<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Vendor Scripts -->
<?= script_asset('frontend/vendor/purecounter/purecounter_vanilla.js') ?>
<?= script_asset('frontend/vendor/aos/aos.js') ?>
<?= script_asset('frontend/vendor/bootstrap/js/bootstrap.bundle.min.js') ?>
<?= script_asset('frontend/vendor/glightbox/js/glightbox.min.js') ?>
<?= script_asset('frontend/vendor/swiper/swiper-bundle.min.js') ?>
<?= script_asset('frontend/js/main.js') ?>

<?php if (get_option('enable_notification_popup') == 1 && get_cookie('home_popup') != 1) : ?>
    <?php set_cookie("home_popup", "1", 180); ?>
    <div class="modal fade" id="notification" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header">
                    <h5 class="modal-title d-flex align-items-center fw-bold">
                        <span class="p-2 bg-light rounded-circle me-3"><i class="bi bi-megaphone text-primary"></i></span>
                        Announcement
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body py-4">
                    <?= get_option('notification_popup_content') ?>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-primary w-100 py-2 fw-semibold" style="border-radius: 12px;" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        window.addEventListener('load', function() {
            setTimeout(function() {
                new bootstrap.Modal(document.getElementById('notification')).show();
            }, 1000);
        });
    </script>
<?php endif; ?>
</body>

</html>
